<?php

namespace App\Models\Facade;

use Illuminate\Support\Facades\DB;

class FinanceiroDB
{
    public static function cobranca($id)
    {
        return DB::table('cobranca as c')
                ->join('tipo_pagamento as tp', 'tp.id', 'c.fk_forma_pagamento')
                ->where('c.id', $id)
                ->whereNull('c.deleted_at')
                ->select(['c.*', 'tp.nome as forma_pagamento'])
                ->first();
    }

    public static function cobrancas($id_cliente=null, $ano=null, $mes=null)
    {
        $sql = DB::table('cobranca as c')
                ->join('tipo_pagamento as tp', 'tp.id', 'c.fk_forma_pagamento')
                ->join('cliente as cli', 'cli.id', 'c.fk_cliente')
                ->whereNull('c.deleted_at');

        if($id_cliente) {
            $sql->where('c.fk_cliente', $id_cliente);
        }

        if($ano) {
            $sql->where('c.ano_ref', $ano);
        }

        if($mes) {
            $sql->where('c.mes_ref', $mes);
        }

        $sql->orderBy('ano_ref');
        $sql->orderBy('mes_ref');

        $pagamentos = $sql->get(['c.*', 'tp.nome as forma_pagamento', 'cli.nome as cliente']);

        return $pagamentos;
    }


    public static function isCobrancaPaga($id_cliente, $ano, $mes)
    {
        return DB::table('cobranca as c')
                ->join('tipo_pagamento as tp', 'tp.id', 'c.fk_forma_pagamento')
                ->whereNull('c.deleted_at')
                ->where('c.fk_cliente', $id_cliente)
                ->where('c.ano_ref', $ano)
                ->where('c.mes_ref', $mes)
                ->first(['c.*', 'tp.nome as forma_pagamento']);
    }

    public static function getUltimaCobrancaPaga($id_cliente)
    {
        return DB::table('cobranca as c')
                ->join('tipo_pagamento as tp', 'tp.id', 'c.fk_forma_pagamento')
                ->where('c.fk_cliente', $id_cliente)
                ->whereNull('c.deleted_at')
                ->select(['c.*', 'tp.nome as forma_pagamento'])
                ->orderBy('c.id', 'DESC')
                ->first();
    }
}
